<?php $__env->startPush('content'); ?>
    <!-- MAIN CONTENT -->
    <div class="main-content">



        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-12">

                    <!-- Header -->
                    <div class="header">
                        <div class="header-body">
                            <div class="row align-items-center">
                                <div class="col">

                                    <!-- Pretitle -->
                                    <h6 class="header-pretitle">
                                        Overview
                                    </h6>

                                    <!-- Title -->
                                    <h1 class="header-title">
                                        Withdrawal Transactions
                                    </h1>

                                </div>
                                
                            </div> <!-- / .row -->
                            <div class="row align-items-center">
                                <div class="col">

                                    <!-- Nav -->
                                    <ul class="nav nav-tabs nav-overflow header-tabs">
                                        <li class="nav-item">
                                            <a href="<?php echo e(url('user/transactions')); ?>" class="nav-link">
                                                Deposit
                                                <span class="badge rounded-pill bg-secondary-soft">
                                                    <?php echo e($DepositCount); ?>

                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="<?php echo e(url('user/transactions/withdraw')); ?>" class="nav-link active">
                                                Withdrawal
                                                <span class="badge rounded-pill bg-secondary-soft">
                                                    <?php echo e($WithdrawCount); ?>

                                                </span>
                                            </a>
                                        </li>
                                        

                                    </ul>

                                </div>
                            </div>
                        </div>
                    </div>




                    <div class="table-responsive">
                        <?php if($transactions->isEmpty()): ?>
                            <!-- Card -->
                            <div class="card card-inactive">
                                <div class="card-body text-center">

                                    <!-- Image -->
                                    <img src="<?php echo e(image_url('scale.svg')); ?>" alt="empty page" class="img-fluid"
                                        style="max-width: 30%; display: unset;">


                                    <!-- Title -->
                                    <h1>
                                        No transactions yet.
                                    </h1>

                                    <!-- Subtitle -->
                                    <p class="text-muted">
                                        Create a new transactions to see your transactions here.
                                    </p>



                                </div>
                            </div>
                        <?php else: ?>
                            <table class="table table-sm table-nowrap card-table">
                                <thead>
                                    <tr>
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-order">
                                                S/N
                                            </a>
                                        </th>
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-order">
                                                Transaction ID
                                            </a>
                                        </th>
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-product">
                                                Type
                                            </a>
                                        </th>
                                        
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-total">
                                                Amount
                                            </a>
                                        </th>

                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-total">
                                                Payment
                                            </a>
                                        </th>
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-product">
                                                Wallet Address
                                            </a>
                                        </th>
                                        <th>
                                            <a href="#" class="text-muted list-sort" data-sort="orders-status">
                                                Status
                                            </a>
                                        </th>

                                        <th colspan="2">
                                            <a href="#" class="text-muted list-sort" data-sort="orders-date">
                                                Date
                                            </a>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="list">

                                    <?php
                                        $counter = 1;
                                    ?>
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="orders-product">
                                                <?php echo e($counter++); ?>

                                            </td>
                                            <td class="orders-order" data-bs-toggle="tooltip"
                                                data-bs-original-title="<?php echo e($value->reference_id); ?>">
                                                #<?php echo e($value->reference_id); ?>

                                            </td>
                                            <td class="orders-product">
                                                Withdrawal
                                            </td>
                                            <td class="orders-total">
                                                <?php echo e(number_format($value->amount, 2)); ?>

                                                USD
                                            </td>

                                            <td class="orders-product">
                                                <?php echo e($user->crypto_type); ?>


                                            </td>

                                            <td class="orders-product">
                                                <?php echo e($user->account_address); ?>


                                            </td>

                                            <td class="orders-status">
                                                <?php if($value->status == 'approved'): ?>
                                                    <div class="badge bg-primary">
                                                        APPROVED
                                                    </div>
                                                <?php elseif($value->status == 'pending'): ?>
                                                    <div class="badge bg-success">
                                                        PENDING
                                                    </div>
                                                <?php else: ?>
                                                    <div class="badge bg-danger">
                                                        DECLINED
                                                    </div>
                                                <?php endif; ?>


                                            <td class="orders-date">
                                                <span title="2 hours ago">
                                                    <?php echo e($value->created_at); ?>

                                                </span>

                                            </td>
                                            <td class="text-end">
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>






                </div>
            </div> <!-- / .row -->

            <!-- Divider -->
            <hr class="my-5">

            <br>
        </div>

    </div> <!-- / .main-content -->
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/user/Documents/Developement/blocktraderinvestments/resources/views/user/transactions/withdraw.blade.php ENDPATH**/ ?>